/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.escape;

import com.mojang.escape.Game;
import com.mojang.escape.InputHandler;
import com.mojang.escape.gui.Screen;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.BufferStrategy;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class EscapeComponent
extends Canvas
implements Runnable {
    private static final long serialVersionUID = 1L;
    private static final int WIDTH = 160;
    private static final int HEIGHT = 120;
    private static final int SCALE = 4;
    private boolean running;
    private Thread thread;
    private Game game;
    private Screen screen;
    private BufferedImage img;
    private int[] pixels;
    private InputHandler inputHandler;
    private Cursor emptyCursor;
    private Cursor defaultCursor;
    private boolean hadFocus = false;

    public EscapeComponent() {
        Dimension size = new Dimension(640, 480);
        this.setSize(size);
        this.setPreferredSize(size);
        this.setMinimumSize(size);
        this.setMaximumSize(size);
        this.game = new Game();
        this.screen = new Screen(160, 120);
        this.img = new BufferedImage(160, 120, 1);
        this.pixels = ((DataBufferInt)this.img.getRaster().getDataBuffer()).getData();
        this.inputHandler = new InputHandler();
        this.addKeyListener(this.inputHandler);
        this.addFocusListener(this.inputHandler);
        this.addMouseListener(this.inputHandler);
        this.addMouseMotionListener(this.inputHandler);
        this.emptyCursor = Toolkit.getDefaultToolkit().createCustomCursor(new BufferedImage(16, 16, 2), new Point(0, 0), "empty");
        this.defaultCursor = this.getCursor();
    }

    public synchronized void start() {
        if (this.running) {
            return;
        }
        this.running = true;
        this.thread = new Thread(this);
        this.thread.start();
    }

    public synchronized void stop() {
        if (!this.running) {
            return;
        }
        this.running = false;
        try {
            this.thread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void run() {
        int frames = 0;
        double unprocessedSeconds = 0.0;
        long lastTime = System.nanoTime();
        double secondsPerTick = 0.016666666666666666;
        int tickCount = 0;
        this.requestFocus();
        while (this.running) {
            long now = System.nanoTime();
            long passedTime = now - lastTime;
            lastTime = now;
            if (passedTime < 0L) {
                passedTime = 0L;
            }
            if (passedTime > 100000000L) {
                passedTime = 100000000L;
            }
            unprocessedSeconds += (double)passedTime / 1.0E9;
            boolean ticked = false;
            while (unprocessedSeconds > secondsPerTick) {
                this.tick();
                unprocessedSeconds -= secondsPerTick;
                ticked = true;
                if (++tickCount % 60 != 0) continue;
                System.out.println(String.valueOf(frames) + " fps");
                lastTime += 1000L;
                frames = 0;
            }
            if (ticked) {
                this.render();
                ++frames;
                continue;
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private void tick() {
        if (this.hasFocus()) {
            this.game.tick(this.inputHandler.keys);
        }
    }

    private void render() {
        BufferStrategy bs;
        if (this.hadFocus != this.hasFocus()) {
            this.hadFocus = !this.hadFocus;
            this.setCursor(this.hadFocus ? this.emptyCursor : this.defaultCursor);
        }
        if ((bs = this.getBufferStrategy()) == null) {
            this.createBufferStrategy(3);
            return;
        }
        this.screen.render(this.game, this.hasFocus());
        int i = 0;
        while (i < 19200) {
            this.pixels[i] = this.screen.pixels[i];
            ++i;
        }
        Graphics g = bs.getDrawGraphics();
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.drawImage(this.img, 0, 0, 640, 480, null);
        g.dispose();
        bs.show();
    }

    public static void main(String[] args) {
        EscapeComponent game = new EscapeComponent();
        JFrame frame = new JFrame("Prelude of the Chambered!");
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)game, "Center");
        frame.setContentPane(panel);
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setResizable(false);
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
        game.start();
    }
}

