/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.chambered.particle;

import com.mojang.chambered.World;
import com.mojang.chambered.display.Camera;
import com.mojang.chambered.display.Renderable;
import com.mojang.chambered.display.Viewport;
import com.mojang.chambered.display.bitmap.BitmapCache;
import com.mojang.chambered.display.bitmap.SpriteImage;
import com.mojang.chambered.level.Level;
import com.mojang.chambered.particle.BounceParticle;
import com.mojang.chambered.particle.Particle;
import java.util.ArrayList;
import java.util.List;

public class ParticleEngine
implements Renderable {
    public List<Particle> particles = new ArrayList<Particle>();
    private World world;
    private SpriteImage sprite;

    public ParticleEngine(World world) {
        this.world = world;
        this.sprite = new SpriteImage(BitmapCache.get("/particle/ball.png"), -8.0);
    }

    public void tick(int currentTick) {
        int i = 0;
        while (i < this.particles.size()) {
            boolean alive = this.particles.get(i).tick();
            if (!alive) {
                this.particles.remove(i--);
            }
            ++i;
        }
    }

    public void testEmittor(int tick) {
        Level level = this.world.level;
        double dir = (double)tick / 60.0 * Math.PI * 2.0;
        double pow = Math.sin((double)tick * 0.02) * 0.5 + 0.5;
        pow *= pow;
        int a = (int)(pow *= 60.0);
        pow *= 0.5;
        int i = 0;
        while (i < a) {
            double xCenter = level.wallWidth * 13.0;
            double zCenter = level.wallWidth * 3.0;
            BounceParticle bounceParticle = new BounceParticle(level, this.sprite, xCenter, -i * 64 / a, zCenter);
            bounceParticle.xa *= 0.1;
            bounceParticle.ya *= 0.1;
            bounceParticle.za *= 0.1;
            bounceParticle.xa += Math.sin(dir) * pow;
            bounceParticle.ya += 0.0;
            bounceParticle.za += Math.cos(dir) * pow;
            this.particles.add(bounceParticle);
            ++i;
        }
    }

    public void render(Viewport viewport, Camera camera, int currentTick, double a) {
        int i = 0;
        while (i < this.particles.size()) {
            this.particles.get(i).render(viewport, camera, currentTick, a);
            ++i;
        }
    }

    public void addParticle(Particle particle) {
        this.particles.add(particle);
    }
}

