/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.chambered.level.tile;

import com.mojang.chambered.display.Wall;
import com.mojang.chambered.display.bitmap.BitmapCache;
import com.mojang.chambered.level.surface.Surface;
import com.mojang.chambered.phys.Collideable;
import com.mojang.chambered.phys.CollisionSphere;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnTile
extends Surface {
    public ColumnTile() {
        double radius = 0.1875;
        int steps = 16;
        int i = 0;
        while (i < steps) {
            int j = (i + 1) % steps;
            double x0 = Math.sin((double)i * Math.PI * 2.0 / (double)steps) * radius + 0.5;
            double y0 = Math.cos((double)i * Math.PI * 2.0 / (double)steps) * radius + 0.5;
            double x1 = Math.sin((double)j * Math.PI * 2.0 / (double)steps) * radius + 0.5;
            double y1 = Math.cos((double)j * Math.PI * 2.0 / (double)steps) * radius + 0.5;
            Wall wall = this.addWall(x0, 0.0, y0, x1, 1.0, y1, true, true, true);
            wall.u0 = (double)i / (double)steps;
            wall.u1 = (double)(i + 1) / (double)steps;
            wall.wallTexture = BitmapCache.get("/wall/stairs.png");
            ++i;
        }
    }

    @Override
    public void getCollideables(List<Collideable> collideables, double xo, double yo) {
        CollisionSphere sphere = new CollisionSphere(xo, yo, 24.0);
        collideables.add(sphere);
    }
}

