/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.chambered.level;

import com.mojang.chambered.World;
import com.mojang.chambered.display.Camera;
import com.mojang.chambered.display.Viewport;
import com.mojang.chambered.display.bitmap.BitmapCache;
import com.mojang.chambered.display.bitmap.DynamicBitmap;
import com.mojang.chambered.display.bitmap.NullBitmap;
import com.mojang.chambered.display.bitmap.SignBitmap;
import com.mojang.chambered.display.bitmap.SpriteImage;
import com.mojang.chambered.entity.ItemEntity;
import com.mojang.chambered.entity.Mob;
import com.mojang.chambered.entity.Monster;
import com.mojang.chambered.entity.Tree;
import com.mojang.chambered.item.Item;
import com.mojang.chambered.item.ItemInstance;
import com.mojang.chambered.level.Tile;
import com.mojang.chambered.level.surface.Surface;
import com.mojang.chambered.phys.Collideable;
import com.mojang.chambered.phys.CollisionSphere;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Level {
    private String map = "#####0##=6#######  o#$##  =#   ##         ## # =#  o####  ##   ###1#####  ## ######<   #      #####3 _    ###  ####>   #  ##9 #######-#######-###. . .   ###a .##:.:. .. 4## .a##..::.. .##7####5aa.::*::#  :###9aa..:.:.    &###..a.. . #  :##############8####";
    public Tile[] tiles;
    private int width = 16;
    private int height = 16;
    private Tile outOfMapTile;
    private SpriteImage[] sprite;
    public double ceilingHeight = Surface.ceilingHeight;
    public double wallWidth = Surface.wallWidth;
    private List<Mob> mobs = new ArrayList<Mob>();
    public World world;

    public Level(World world) {
        this.world = world;
        this.outOfMapTile = new Tile(world, this, -1, -1, true);
        this.sprite = new SpriteImage[2];
        this.sprite[0] = new SpriteImage(BitmapCache.get("/monster.png"), -8.0);
        this.sprite[1] = new SpriteImage(BitmapCache.get("/monsterattack.png"), -8.0);
        String solidChars = "#=<>&1234567890";
        this.tiles = new Tile[this.width * this.height];
        int x = 0;
        while (x < this.width) {
            int y = 0;
            while (y < this.height) {
                Tree tree;
                double yOffs;
                int i;
                char ch = this.map.charAt(x + y * 16);
                boolean solid = solidChars.indexOf(ch) >= 0;
                Tile tile = new Tile(world, this, x, y, solid);
                if (ch == '#') {
                    tile.wallType = Surface.flat;
                }
                if (ch == '=') {
                    tile.wallType = Surface.niche;
                }
                if (ch == '-') {
                    tile.wallType = Surface.door;
                }
                if (ch == '_') {
                    tile.wallType = Surface.pressurePlate;
                }
                if (ch == '*') {
                    tile.wallType = Surface.pit;
                }
                if (ch == 'o') {
                    tile.wallType = Surface.column;
                }
                if (ch == '<') {
                    tile.wallType = Surface.stairsUp;
                }
                if (ch == '>') {
                    tile.wallType = Surface.stairsDown;
                }
                if (ch == '&') {
                    tile.wallType = Surface.flat.setWallTexture(new DynamicBitmap(128, 96));
                }
                if (ch == '1') {
                    tile.wallType = Surface.flat.setWallTexture(new SignBitmap(128, 96, "Welcome!"));
                }
                if (ch == '2') {
                    tile.wallType = Surface.flat.setWallTexture(new SignBitmap(128, 96, "Particles!"));
                }
                if (ch == '3') {
                    tile.wallType = Surface.flat.setWallTexture(new SignBitmap(128, 96, "Stairs!"));
                }
                if (ch == '4') {
                    tile.wallType = Surface.flat.setWallTexture(new SignBitmap(128, 96, "Woods!"));
                }
                if (ch == '5') {
                    tile.wallType = Surface.flat.setWallTexture(new SignBitmap(128, 96, "Monsters!"));
                }
                if (ch == '6') {
                    tile.wallType = Surface.flat.setWallTexture(new SignBitmap(128, 96, "Niches!"));
                }
                if (ch == '7') {
                    tile.wallType = Surface.flat.setWallTexture(new SignBitmap(128, 96, "Win!"));
                }
                if (ch == '8') {
                    tile.wallType = Surface.flat.setWallTexture(new SignBitmap(128, 96, "Yay!"));
                }
                if (ch == '9') {
                    tile.wallType = Surface.flat.setWallTexture(new SignBitmap(128, 96, "(dancing)"));
                }
                if (ch == '0') {
                    tile.wallType = Surface.flat.setWallTexture(new SignBitmap(128, 96, "Loot!"));
                }
                this.tiles[x + y * 16] = tile;
                if (y > 8) {
                    tile.ceilingTexture = new NullBitmap(128, 128);
                }
                if (ch == '$') {
                    int j = 0;
                    while (j < 4) {
                        int i2 = 0;
                        while (i2 < 10) {
                            double xOffs = (Math.random() - 0.5) * 0.75 * this.wallWidth;
                            double yOffs2 = (Math.random() - 0.5) * 0.75 * this.wallWidth;
                            this.addItem(new ItemInstance(world, Item.items[i2]), (double)x * this.wallWidth + xOffs, 0.0, (double)y * this.wallWidth + yOffs2);
                            ++i2;
                        }
                        ++j;
                    }
                }
                if (ch == '.') {
                    i = (int)(Math.random() * 4.0);
                    double xOffs = (double)(i % 2) * this.wallWidth / 2.0 - this.wallWidth / 4.0;
                    yOffs = (double)(i / 2) * this.wallWidth / 2.0 - this.wallWidth / 4.0;
                    tree = new Tree((double)x * this.wallWidth + xOffs, 0.0, (double)y * this.wallWidth + yOffs);
                    this.addApples(world, tree);
                    tile.addEntity(tree);
                }
                if (ch == ':') {
                    i = 0;
                    while (i < 4) {
                        double xOffs = (double)(i % 2) * this.wallWidth / 2.0 - this.wallWidth / 4.0;
                        yOffs = (double)(i / 2) * this.wallWidth / 2.0 - this.wallWidth / 4.0;
                        tree = new Tree((double)x * this.wallWidth + xOffs, 0.0, (double)y * this.wallWidth + yOffs);
                        this.addApples(world, tree);
                        tile.addEntity(tree);
                        ++i;
                    }
                }
                if (ch == 'a') {
                    this.addMob(new Monster(world, this.sprite[0], this.sprite[1], (double)x * this.wallWidth, 0.0, (double)y * this.wallWidth));
                }
                ++y;
            }
            ++x;
        }
    }

    private void addApples(World world, Tree tree) {
        int count = (int)(Math.random() * 6.0 - 2.0);
        int i = 0;
        while (i < count) {
            double dir = Math.random() * Math.PI * 2.0;
            double dist = Math.random() * 16.0 + 16.0;
            double xo = Math.sin(dir) * dist;
            double zo = Math.cos(dir) * dist;
            this.addItem(new ItemInstance(world, Item.apple), tree.x + xo, 0.0, tree.z + zo);
            ++i;
        }
        count = (int)(Math.random() * 6.0 - 2.0);
        i = 0;
        while (i < count) {
            ItemEntity apple = new ItemEntity(new ItemInstance(world, Item.apple), tree.x, tree.y, tree.z);
            tree.addItemEntity(apple);
            ++i;
        }
    }

    public void addItem(ItemInstance itemInstance, double x, double y, double z) {
        this.getTileAt(x, z).addEntity(new ItemEntity(itemInstance, x, y, z));
    }

    public void addMob(Mob mob) {
        this.mobs.add(mob);
    }

    public Tile getTile(int x, int y) {
        if (x < 0 || y < 0 || x >= 16 || y >= 16) {
            return this.outOfMapTile;
        }
        return this.tiles[x + y * 16];
    }

    public Tile getTileAt(double x, double y) {
        int xTile = (int)(x / this.wallWidth + 0.5);
        int yTile = (int)(y / this.wallWidth + 0.5);
        return this.getTile(xTile, yTile);
    }

    public List<Collideable> getCollideables(double x, double y, long mask) {
        ArrayList<Collideable> collideables = new ArrayList<Collideable>();
        int xTile = (int)(x / this.wallWidth);
        int yTile = (int)(y / this.wallWidth);
        int xt = xTile;
        while (xt <= xTile + 1) {
            int yt = yTile;
            while (yt <= yTile + 1) {
                this.getTile(xt, yt).getCollideables(collideables, mask);
                ++yt;
            }
            ++xt;
        }
        return collideables;
    }

    public boolean isFree(CollisionSphere s, long mask) {
        List<Collideable> collideables = this.getCollideables(s.pos.x, s.pos.y, mask);
        int i = 0;
        while (i < collideables.size()) {
            if (collideables.get(i).isInside(s)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void tick(int currentTick) {
        int i = 0;
        while (i < this.mobs.size()) {
            Mob mob = this.mobs.get(i);
            boolean alive = mob.tick();
            if (!alive) {
                this.mobs.remove(i--);
                mob.removed();
            }
            ++i;
        }
    }

    public void renderSprites(Viewport viewport, Camera camera, int currentTick, double alpha) {
        int i = 0;
        while (i < this.mobs.size()) {
            this.mobs.get(i).render(viewport, camera, currentTick, alpha);
            ++i;
        }
    }

    public void hurtMonsters(double x, double z, Camera camera) {
        int i = 0;
        while (i < this.mobs.size()) {
            Mob mob = this.mobs.get(i);
            if (mob instanceof Monster) {
                Monster monster = (Monster)mob;
                double xd = monster.x - x;
                double zd = monster.z - z;
                double d = xd * xd + zd * zd;
                if (d < 16384.0 && monster.isInFront(camera, 0.5)) {
                    monster.hurt();
                }
            }
            ++i;
        }
    }
}

