/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.chambered.gui;

import com.mojang.chambered.World;
import com.mojang.chambered.display.Font;
import com.mojang.chambered.display.bitmap.Bitmap;
import com.mojang.chambered.display.bitmap.BitmapCache;
import com.mojang.chambered.gui.Component;
import com.mojang.chambered.gui.CursorManager;
import com.mojang.chambered.gui.HeroPanel;
import com.mojang.chambered.gui.InventoryPanel;
import com.mojang.chambered.gui.particle.GuiParticle;
import com.mojang.chambered.hero.Hero;
import com.mojang.chambered.item.ItemInstance;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Gui
extends Component {
    public static final int ACTION_OPEN_INVENTORY_1 = 1;
    public static final int ACTION_OPEN_INVENTORY_2 = 2;
    public static final int ACTION_OPEN_INVENTORY_3 = 3;
    public static final int ACTION_OPEN_INVENTORY_4 = 4;
    public static final int ACTION_CLOSE_INVENTORIES = 5;
    private BufferedImage image;
    private Bitmap bitmap;
    private Bitmap staticBitmap;
    public ItemInstance carried;
    private Bitmap bottomBg = BitmapCache.get("/gui/panel.png");
    private HeroPanel[] heroPanels = new HeroPanel[4];
    private InventoryPanel inventoryPanel = null;
    private Map<Hero, InventoryPanel> inventoryPanelMap = new HashMap<Hero, InventoryPanel>();
    private boolean dirty = true;
    private CursorManager cursorManager;
    private boolean inventoryOpen = false;
    private List<GuiParticle> particles = new ArrayList<GuiParticle>();

    public Gui(World world, CursorManager cursorManager, int width, int height) {
        super(world, 0, 0, width, 240);
        this.cursorManager = cursorManager;
        this.image = new BufferedImage(width, height, 2);
        this.bitmap = new Bitmap(this.image);
        this.staticBitmap = new Bitmap(width, height);
        int i = 0;
        while (i < 4) {
            this.inventoryPanelMap.put(world.party.heroes[i], new InventoryPanel(world, 4, height - 69, world.party.heroes[i]));
            ++i;
        }
        i = 0;
        while (i < 4) {
            int xp = width / 2 + (i - 2) * 60;
            int yp = height - 64 + (i - 1 & 2) * 5 - 5;
            this.heroPanels[i] = new HeroPanel(world, xp, yp, world.party.heroes[i]);
            this.addChild(this.heroPanels[i]);
            ++i;
        }
    }

    private void redrawStatic() {
        this.staticBitmap.blit(this.bottomBg, 0, this.height - this.bottomBg.height);
        this.renderChildren(this.staticBitmap);
    }

    public void tick(int currentTick) {
        super.tick(currentTick);
        int i = 0;
        while (i < this.particles.size()) {
            boolean alive = this.particles.get(i).tick(currentTick);
            if (!alive) {
                this.particles.remove(i--);
            }
            ++i;
        }
    }

    public void addParticleOnPortrait(Hero hero, GuiParticle particle, int xo, int yo) {
        if (this.inventoryOpen) {
            if (this.inventoryPanel.hero == hero) {
                this.inventoryPanel.addParticleOnPortrait(particle, xo, yo);
                this.addParticle(particle);
            }
        } else {
            int i = 0;
            while (i < this.heroPanels.length) {
                if (this.heroPanels[i].hero == hero) {
                    this.heroPanels[i].addParticleOnPortrait(particle, xo, yo);
                    this.addParticle(particle);
                }
                ++i;
            }
        }
    }

    public void addParticle(GuiParticle particle) {
        this.particles.add(particle);
    }

    public void render(int xMouse, int yMouse, int currentTick, double alpha) {
        if (this.dirty) {
            this.redrawStatic();
            this.dirty = false;
        }
        this.renderDirtyChildren(this.staticBitmap);
        this.bitmap.blit(this.staticBitmap, 0, 0);
        int i = 0;
        while (i < this.particles.size()) {
            this.particles.get(i).render(this.bitmap, currentTick, alpha);
            ++i;
        }
        if (!this.cursorManager.setCursor(this.carried) && this.carried != null) {
            this.bitmap.blit(this.carried.getInventorySprite(), xMouse, yMouse + 8);
        }
        if (this.carried != null) {
            int x = (this.width - Font.normal.width(this.carried.getName())) / 2;
            Font.normal.drawShadow(this.bitmap, this.carried.getName(), x, this.height - 9, 0xFFFFFF);
        }
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public void renderFps(int fps) {
        Font.normal.draw(this.bitmap, "Fps: " + fps, 0, 0, 0xFFFFFF);
    }

    public Component getComponentAt(int x, int y) {
        if (x >= 0 && y >= this.height - this.bottomBg.height && x < this.width && y < this.height) {
            return this;
        }
        return null;
    }

    public void openInventory(Hero hero) {
        if (this.inventoryOpen) {
            boolean isCurrent = this.inventoryPanel == this.inventoryPanelMap.get(hero);
            this.closeInventory();
            if (isCurrent) {
                return;
            }
        }
        this.inventoryOpen = true;
        this.dirty = true;
        int i = 0;
        while (i < 4) {
            this.removeChild(this.heroPanels[i]);
            ++i;
        }
        this.inventoryPanel = this.inventoryPanelMap.get(hero);
        this.addChild(this.inventoryPanel);
    }

    public void closeInventory() {
        if (!this.inventoryOpen) {
            return;
        }
        this.inventoryOpen = false;
        this.dirty = true;
        this.removeChild(this.inventoryPanel);
        int i = 0;
        while (i < 4) {
            this.addChild(this.heroPanels[i]);
            ++i;
        }
    }

    public void performAction(int action) {
        if (action == 1) {
            this.openInventory(this.world.party.heroes[0]);
        } else if (action == 2) {
            this.openInventory(this.world.party.heroes[1]);
        } else if (action == 3) {
            this.openInventory(this.world.party.heroes[2]);
        } else if (action == 4) {
            this.openInventory(this.world.party.heroes[3]);
        } else if (action == 5) {
            this.closeInventory();
        }
    }
}

