/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.chambered.display;

import com.mojang.chambered.display.Camera;
import com.mojang.chambered.display.PickResult;
import com.mojang.chambered.display.Pickable;
import com.mojang.chambered.display.Wall;
import com.mojang.chambered.display.bitmap.AbstractBitmap;
import com.mojang.chambered.display.bitmap.Bitmap;
import com.mojang.chambered.display.bitmap.BitmapCache;
import com.mojang.chambered.display.bitmap.SpriteImage;
import java.awt.image.BufferedImage;
import java.util.Arrays;

public class Viewport {
    public int width;
    public int height;
    private int xCenter;
    public int yCenter;
    private double fovScale;
    public Bitmap bitmap;
    private int[] color;
    private int[] zBuffer;
    private int[] brightness;
    private int[] yMins;
    private int[] yMaxs;
    private int xMin;
    private int xMax;
    private BufferedImage image;
    private AbstractBitmap skyTexture;
    private static final int FULL_BRIGHT = 0x10000000;
    private static final int FAR_DISTANCE = 0xFFFFFFF;
    public static final int MAX_PICK_DISTANCE = 180;
    private Camera camera;
    private int xClip0;
    private int xClip1;
    public boolean pick;
    public PickResult pickResult;
    private double[] xl;
    private double[] zl;
    private int xPick;
    private int yPick;

    public Viewport(int width, int height) {
        this.width = width;
        this.height = height;
        this.skyTexture = BitmapCache.get("/sky.png");
        this.xCenter = (int)((double)width * 0.5);
        this.yCenter = (int)((double)height * 0.333);
        this.fovScale = height;
        this.yMins = new int[width];
        this.yMaxs = new int[width];
        this.image = new BufferedImage(width, height, 1);
        this.bitmap = new Bitmap(this.image);
        this.color = new int[width * height];
        this.zBuffer = new int[width * height];
        this.brightness = new int[width * height];
        this.xl = new double[width];
        this.zl = new double[width];
        int x = 0;
        while (x < width) {
            double xl = x - this.xCenter;
            double zl = 1.0 * this.fovScale;
            double zzd = Math.sqrt(xl * xl + zl * zl);
            this.xl[x] = -(xl /= zzd);
            this.zl[x] = -(zl /= zzd);
            ++x;
        }
    }

    public void clear(Camera camera) {
        this.xMin = 0;
        this.xMax = this.width;
        Arrays.fill(this.yMins, 0);
        Arrays.fill(this.yMaxs, this.height);
        Arrays.fill(this.zBuffer, 0xFFFFFFF);
        int xOffs = (int)(camera.rot * 320.0 * 4.0 / (Math.PI * 2)) % 320;
        if (xOffs < 0) {
            xOffs += 320;
        }
        int[] skyPixels = this.skyTexture.getPixels();
        Arrays.fill(this.zBuffer, 0, 17600, 0x10000000);
        Arrays.fill(this.brightness, 0, 17600, 255);
        int y = 0;
        while (y < 55) {
            System.arraycopy(skyPixels, y * 320 + xOffs, this.color, y * 320, 320 - xOffs);
            System.arraycopy(skyPixels, y * 320, this.color, y * 320 + 320 - xOffs, xOffs);
            ++y;
        }
        this.pick = false;
    }

    public void pick(int x, int y) {
        this.xPick = x;
        this.yPick = y;
        int margin = 0;
        this.xMin = x - margin;
        this.xMax = x + 1 + margin;
        int yMin = y - margin;
        int yMax = y + 1 + margin;
        if (this.xMin < 0) {
            this.xMin = 0;
        }
        if (yMin < 0) {
            yMin = 0;
        }
        if (this.xMax >= this.width) {
            this.xMax = this.width - 1;
        }
        if (yMax >= this.height) {
            yMax = this.height - 1;
        }
        int xx = this.xMin;
        while (xx < this.xMax) {
            this.yMins[xx] = yMin;
            this.yMaxs[xx] = yMax;
            int yy = yMin;
            while (yy < yMax) {
                this.zBuffer[xx + yy * this.width] = 0xFFFFFFF;
                ++yy;
            }
            ++xx;
        }
        this.pick = true;
        this.pickResult = null;
    }

    public void unclip() {
        this.xClip0 = 0;
        this.xClip1 = this.width;
    }

    public void clip(Wall wall) {
        this.xClip0 = this.width;
        this.xClip1 = 0;
        if (this.xMin >= this.xMax) {
            return;
        }
        double xRight = wall.x1 / wall.z1 * this.fovScale + (double)this.xCenter;
        int x1 = (int)xRight;
        double xLeft = wall.x0 / wall.z0 * this.fovScale + (double)this.xCenter;
        int x0 = (int)xLeft;
        if (x1 <= x0 || x1 <= this.xMin || x0 >= this.xMax) {
            return;
        }
        this.xClip0 = x0;
        this.xClip1 = x1;
    }

    /*
     * Unable to fully structure code
     */
    public void renderSprite(SpriteImage sprite, Pickable pickable) {
        if (sprite.z < 0.1) {
            return;
        }
        scale = this.fovScale / sprite.z;
        left = (int)((sprite.x - sprite.xo) * scale + (double)this.xCenter);
        right = (int)((sprite.x - sprite.xo + sprite.w) * scale + (double)this.xCenter);
        x0 = left;
        x1 = right;
        if (x0 < 0) {
            x0 = 0;
        }
        if (x1 >= this.width) {
            x1 = this.width;
        }
        if (x1 < 0 || x0 > this.width) {
            return;
        }
        top = (int)((sprite.y - sprite.yo) * scale + (double)this.yCenter);
        bottom = (int)((sprite.y - sprite.yo + sprite.h) * scale + (double)this.yCenter);
        y0 = top;
        y1 = bottom;
        if (y0 < 0) {
            y0 = 0;
        }
        if (y1 >= this.height) {
            y1 = this.height;
        }
        if (y1 < 0 || y0 > this.height) {
            return;
        }
        if (this.pick) {
            margin = 0;
            if (x0 < this.xPick - margin) {
                x0 = this.xPick - margin;
            }
            if (x1 > this.xPick + margin) {
                x1 = this.xPick + 1 + margin;
            }
            if (y0 < this.yPick - margin) {
                y0 = this.yPick - margin;
            }
            if (y1 > this.yPick + margin) {
                y1 = this.yPick + 1 + margin;
            }
        }
        z = (int)sprite.z;
        tex = sprite.texture.getPixels();
        texWidth = sprite.texture.getWidth();
        texHeight = sprite.texture.getHeight();
        xd = right - left;
        xo = xd / 2;
        ud = sprite.u1 - sprite.u0;
        uo = sprite.u0;
        if (sprite.mirror) {
            ud = sprite.u0 - sprite.u1;
            uo = sprite.u1 - 1;
        }
        yd = bottom - top;
        yo = yd / 2;
        vd = sprite.v1 - sprite.v0;
        vo = sprite.v0;
        y = y0;
        while (y < y1) {
            block32: {
                block34: {
                    block33: {
                        v = vo + (vd * (y - top) + yo) / yd;
                        if (v < 0 || v >= texHeight) break block32;
                        pixel = y * this.width + x0;
                        if (!this.pick) break block33;
                        x = x0;
                        while (x < x1) {
                            if (this.zBuffer[pixel] > z) {
                                u = uo + (ud * (x - left) + xo) / xd;
                                if (u >= 0 && u < texWidth) {
                                    col = tex[v * texWidth + u];
                                    if (col != 0) {
                                        this.zBuffer[pixel] = z;
                                        if (z < 180) {
                                            this.pickResult = new PickResult(pickable, u, v).setSprite();
                                        }
                                        return;
                                    } else {
                                        ** GOTO lbl-1000
                                    }
                                }
                            } else lbl-1000:
                            // 3 sources

                            {
                                ++pixel;
                            }
                            ++x;
                        }
                        break block32;
                    }
                    if (sprite.solidColor == 0) break block34;
                    x = x0;
                    while (x < x1) {
                        block36: {
                            block35: {
                                if (this.zBuffer[pixel] <= z) break block35;
                                u = uo + (ud * (x - left) + xo) / xd;
                                if (u < 0 || u >= texWidth) break block36;
                                col = tex[v * texWidth + u];
                                if (col != 0) {
                                    this.color[pixel] = sprite.solidColor;
                                    this.zBuffer[pixel] = z;
                                    this.brightness[pixel] = sprite.brightness;
                                }
                            }
                            ++pixel;
                        }
                        ++x;
                    }
                    break block32;
                }
                x = x0;
                while (x < x1) {
                    block38: {
                        block37: {
                            if (this.zBuffer[pixel] <= z) break block37;
                            u = uo + (ud * (x - left) + xo) / xd;
                            if (u < 0 || u >= texWidth) break block38;
                            col = tex[v * texWidth + u];
                            if (col != 0) {
                                this.color[pixel] = col;
                                this.zBuffer[pixel] = z;
                                this.brightness[pixel] = sprite.brightness;
                            }
                        }
                        ++pixel;
                    }
                    ++x;
                }
            }
            ++y;
        }
    }

    public void renderWall(Wall wall, Pickable pickable) {
        int wallTexHeight;
        if (this.pick && this.pickResult != null) {
            return;
        }
        if (!wall.visible || this.xMin >= this.xMax || this.xClip0 > this.xClip1) {
            return;
        }
        boolean hasFloor = wall.hasFloor;
        boolean hasCeiling = wall.hasCeiling;
        boolean hasWall = wall.hasWall;
        if (!(hasWall || hasFloor || hasCeiling)) {
            return;
        }
        double xLeft = wall.x0 / wall.z0 * this.fovScale + (double)this.xCenter;
        double xRight = wall.x1 / wall.z1 * this.fovScale + (double)this.xCenter;
        int x0 = (int)xLeft;
        int x1 = (int)xRight;
        if (this.pick) {
            if (x0 < this.xPick) {
                x0 = this.xPick;
            }
            if (x1 > this.xPick) {
                x1 = this.xPick + 1;
            }
        }
        if (x1 <= x0 || x1 <= this.xMin || x0 >= this.xMax) {
            return;
        }
        double yTopLeft = wall.y0 / wall.z0 * this.fovScale + (double)this.yCenter;
        double yTopRight = wall.y0 / wall.z1 * this.fovScale + (double)this.yCenter;
        double yTopDelta = yTopRight - yTopLeft;
        double yBottomLeft = wall.y1 / wall.z0 * this.fovScale + (double)this.yCenter;
        double yBottomRight = wall.y1 / wall.z1 * this.fovScale + (double)this.yCenter;
        double yBottomDelta = yBottomRight - yBottomLeft;
        if (!hasCeiling && !hasFloor && wall.y0 >= wall.y1) {
            return;
        }
        if (!hasFloor && yBottomLeft <= 0.0 && yBottomRight <= 0.0) {
            return;
        }
        if (!hasCeiling && yTopLeft >= (double)this.height && yTopRight >= (double)this.height) {
            return;
        }
        if (!hasWall && yTopLeft <= 0.0 && yTopRight <= 0.0 && yBottomLeft >= (double)this.height && yBottomRight >= (double)this.height) {
            return;
        }
        double xDelta = xRight - xLeft;
        int leftClip = this.xMin;
        int rightClip = this.xMax;
        if (leftClip < this.xClip0) {
            leftClip = this.xClip0;
        }
        if (rightClip > this.xClip1) {
            rightClip = this.xClip1;
        }
        if (x0 < leftClip) {
            x0 = leftClip;
        }
        if (x1 > rightClip) {
            x1 = rightClip;
        }
        double iz0 = 1.0 / wall.z0;
        double izd = 1.0 / wall.z1 - iz0;
        wall.calcNormal();
        int[] ceilingTex = hasCeiling ? wall.ceilingTexture.getPixels() : null;
        int[] floorTex = hasFloor ? wall.floorTexture.getPixels() : null;
        int[] wallTex = hasWall ? wall.wallTexture.getPixels() : null;
        int ceilingTexWidth = hasCeiling ? wall.ceilingTexture.getWidth() : 0;
        int floorTexWidth = hasFloor ? wall.floorTexture.getWidth() : 0;
        int wallTexWidth = hasWall ? wall.wallTexture.getWidth() : 0;
        int ceilingTexHeight = hasCeiling ? wall.ceilingTexture.getHeight() : 0;
        int floorTexHeight = hasFloor ? wall.floorTexture.getHeight() : 0;
        int n = wallTexHeight = hasWall ? wall.wallTexture.getHeight() : 0;
        if (hasCeiling && (ceilingTexWidth != 128 || ceilingTexHeight != 128) || hasFloor && (floorTexWidth != 128 || floorTexHeight != 128)) {
            throw new IllegalArgumentException("Floor and ceiling textures have to be 128x128");
        }
        double iu0 = wall.u0 * (double)wallTexWidth / wall.z0;
        double iud = wall.u1 * (double)wallTexWidth / wall.z1 - iu0;
        int x = x0;
        while (x < x1) {
            int yMax = this.yMaxs[x];
            int yMin = this.yMins[x];
            if (yMax > yMin) {
                double a = ((double)x - xLeft + 1.0) / xDelta;
                double _y0 = yTopLeft + yTopDelta * a;
                double _y1 = yBottomLeft + yBottomDelta * a;
                int y0 = (int)_y0;
                int y1 = (int)_y1;
                if (this.pick) {
                    if (y0 < this.yPick) {
                        y0 = this.yPick;
                    }
                    if (y1 > this.yPick) {
                        y1 = this.yPick + 1;
                    }
                }
                if (!(!hasCeiling && !hasFloor && y1 <= y0 || !hasFloor && y1 <= yMin || !hasCeiling && y0 >= yMax || !hasWall && y0 <= yMin && y1 >= yMax)) {
                    int fv;
                    double z;
                    int y;
                    double vFloor;
                    double _vFloor;
                    double _uFloor;
                    if (y0 < yMin) {
                        y0 = yMin;
                    }
                    if (y1 > yMax) {
                        y1 = yMax;
                    }
                    int pixel = yMin * this.width + x;
                    if (y0 < this.yCenter && y0 > yMin && hasCeiling) {
                        _uFloor = (double)(x - this.xCenter) * wall.y0;
                        _vFloor = 1.0 * this.fovScale * wall.y0;
                        double uFloor = _uFloor * this.camera.cos + _vFloor * this.camera.sin;
                        vFloor = -_vFloor * this.camera.cos + _uFloor * this.camera.sin;
                        if (y0 > yMax) {
                            y0 = yMax;
                        }
                        if (this.pick) {
                            double z2 = yMin - this.yCenter + 1;
                            int fu = (int)(-uFloor / z2 + this.camera.x);
                            int fv2 = (int)(vFloor / z2 - this.camera.z);
                            this.zBuffer[pixel] = (int)(_vFloor / z2);
                            if ((int)(_vFloor / z2) < 180) {
                                this.pickResult = new PickResult(pickable, -fu, fv2).setCeiling();
                            }
                            return;
                        }
                        if (ceilingTex != null) {
                            y = yMin;
                            while (y < y0) {
                                z = y - this.yCenter + 1;
                                int fu = (int)(-uFloor / z + this.camera.x + 64.0) & 0x7F;
                                fv = (int)(vFloor / z - this.camera.z + 64.0) & 0x7F;
                                this.color[pixel] = ceilingTex[fv << 7 | fu];
                                this.zBuffer[pixel] = (int)(_vFloor / z);
                                this.brightness[pixel] = 200;
                                pixel += this.width;
                                ++y;
                            }
                        } else {
                            pixel += this.width * (y0 - yMin);
                        }
                        if (y0 > yMin) {
                            this.yMins[x] = yMin = y0;
                        }
                    } else {
                        pixel += this.width * (y0 - yMin);
                    }
                    if (y1 > y0 && y1 > yMin && y0 < yMax && hasWall) {
                        double iz = iz0 + izd * a;
                        double iu = iu0 + iud * a;
                        int u = (int)(iu / iz - 0.5) % wallTexWidth;
                        double v0 = wall.v0 * (double)wallTexHeight;
                        double vd = wall.v1 * (double)wallTexHeight - v0;
                        double yd = _y1 - _y0;
                        double va = vd * 1.0 / yd;
                        double vv = v0 + ((double)y0 - _y0) * va;
                        int z3 = (int)(1.0 / iz);
                        if (this.pick) {
                            int v = (int)vv;
                            this.zBuffer[pixel] = z3;
                            if (z3 < 180) {
                                this.pickResult = new PickResult(pickable, u, v).setWall();
                            }
                            return;
                        }
                        double brr = (wall.xn * this.xl[x] + wall.zn * this.zl[x]) * 0.9 + 0.1;
                        int br = (int)((double)wall.brightness * brr);
                        int y2 = y0;
                        while (y2 < y1) {
                            int v = (int)(vv + (double)wallTexHeight) % wallTexHeight;
                            this.color[pixel] = wallTex[v * wallTexWidth + u];
                            this.zBuffer[pixel] = z3;
                            this.brightness[pixel] = br;
                            vv += va;
                            pixel += this.width;
                            ++y2;
                        }
                    } else {
                        pixel += this.width * (y1 - y0);
                    }
                    if (y1 >= this.yCenter && y1 < yMax && hasFloor) {
                        _uFloor = (double)(x - this.xCenter) * wall.y1;
                        _vFloor = 1.0 * this.fovScale * wall.y1;
                        double uFloor = _uFloor * this.camera.cos + _vFloor * this.camera.sin;
                        vFloor = -_vFloor * this.camera.cos + _uFloor * this.camera.sin;
                        if (y1 < yMin) {
                            pixel += (yMin - y1) * this.width;
                            y1 = yMin;
                        }
                        if (this.pick) {
                            double z4 = y1 - this.yCenter + 1;
                            int fu = (int)(-uFloor / z4 + this.camera.x);
                            int fv3 = (int)(vFloor / z4 - this.camera.z);
                            this.zBuffer[pixel] = (int)(_vFloor / z4);
                            if ((int)(_vFloor / z4) < 180) {
                                this.pickResult = new PickResult(pickable, -fu, fv3).setFloor();
                            }
                            return;
                        }
                        y = y1;
                        while (y < yMax) {
                            z = y - this.yCenter + 1;
                            int fu = (int)(-uFloor / z + this.camera.x + 128.0) / 2 & 0x7F;
                            fv = (int)(vFloor / z - this.camera.z + 128.0) / 2 & 0x7F;
                            this.color[pixel] = floorTex[fv << 7 | fu];
                            this.zBuffer[pixel] = (int)(_vFloor / z);
                            this.brightness[pixel] = 200;
                            pixel += this.width;
                            ++y;
                        }
                        if (y1 < yMax) {
                            yMax = this.yMaxs[x] = y1;
                        }
                    }
                    if (hasWall) {
                        if ((y0 <= yMin || hasCeiling) && y1 > yMin) {
                            yMin = this.yMins[x] = y1;
                        }
                        if ((y1 >= yMax || hasFloor) && y0 < yMax) {
                            yMax = this.yMaxs[x] = y0;
                        }
                        if (y0 <= yMin && y1 > yMin) {
                            yMin = this.yMins[x] = y1;
                        }
                        if (y1 >= yMax && y0 < yMax) {
                            yMax = this.yMaxs[x] = y0;
                        }
                    }
                }
            }
            ++x;
        }
        if (hasFloor && hasWall && hasCeiling && x0 <= this.xMin) {
            this.xMin = x1;
        }
        if (hasFloor && hasWall && hasCeiling && x1 >= this.xMax) {
            this.xMax = x0;
        }
        while (this.xMin < this.width && this.xMin < this.xMax && this.yMins[this.xMin] >= this.yMaxs[this.xMin]) {
            ++this.xMin;
        }
        while (this.xMax > 0 && this.xMin < this.xMax && this.yMins[this.xMax - 1] >= this.yMaxs[this.xMax - 1]) {
            --this.xMax;
        }
    }

    public void setCameraPos(Camera camera) {
        this.camera = camera;
    }

    public boolean isFilled() {
        return this.xMin >= this.xMax;
    }

    public BufferedImage render() {
        int[] pixels = this.bitmap.pixels;
        int p = 0;
        int y = 0;
        while (y < this.height) {
            double xaa = 1.0 / this.fovScale;
            double xa = (double)(-this.xCenter) * xaa;
            double ya = (double)(y - this.yCenter + 1) / this.fovScale;
            int x = 0;
            while (x < this.width) {
                double zz = this.zBuffer[p] & 0xFFFFFFF;
                double xx = xa * zz * 2.0;
                double yy = ya * zz * 2.0;
                double d = xx * xx + yy * yy + zz * zz + 10000.0;
                int br = (int)((double)(this.brightness[p] * 30000) / d);
                if (br > 256) {
                    br = 256;
                }
                int col = this.color[p];
                int r = (col >> 16 & 0xFF) * br >> 8;
                int g = (col >> 8 & 0xFF) * br >> 8;
                int b = (col & 0xFF) * br >> 8;
                pixels[p++] = r << 16 | g << 8 | b;
                xa += xaa;
                ++x;
            }
            ++y;
        }
        return this.image;
    }

    public double getAngle(int x) {
        double xaa = 1.0 / this.fovScale;
        double xa = (double)(x - this.xCenter) * xaa;
        double ya = 1.0;
        return Math.atan2(xa, ya);
    }
}

