/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.chambered.display;

import com.mojang.chambered.display.Camera;
import com.mojang.chambered.display.PickResult;
import com.mojang.chambered.display.Pickable;
import com.mojang.chambered.display.Renderable;
import com.mojang.chambered.display.Viewport;
import com.mojang.chambered.display.Wall;
import com.mojang.chambered.display.bitmap.BitmapCache;
import com.mojang.chambered.level.Level;
import com.mojang.chambered.level.Tile;
import com.mojang.chambered.level.surface.Surface;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LevelRenderer {
    private Viewport viewport;
    private Camera camera;
    private Level level;
    private boolean pick = false;
    private int xPick;
    private int yPick;
    private List<Tile> visibleTiles = new ArrayList<Tile>();

    public LevelRenderer(Level level) {
        this.level = level;
        Surface.defaultCeilingTexture.texture = BitmapCache.get("/floor/dirt.png");
        Surface.defaultFloorTexture.texture = BitmapCache.get("/floor/dirt.png");
        Surface.defaultWallTexture.texture = BitmapCache.get("/wall/rock.png");
    }

    private void renderBlock(int x, int z, int xOffs, int zOffs) {
        if (this.viewport.isFilled()) {
            return;
        }
        Tile tile = this.level.getTile(x += xOffs, z += zOffs);
        this.visibleTiles.add(tile);
        if (tile.isSolid()) {
            int rot = 0;
            while (rot < 4) {
                Surface surface;
                if (!(rot == 0 && z >= zOffs || rot == 1 && x >= xOffs || rot == 2 && z <= zOffs || rot == 3 && x <= xOffs || (surface = tile.getWall(rot)) == null)) {
                    Wall wall = surface.clipWall.move(x, 0, z, rot);
                    wall.ceilingTexture = tile.ceilingTexture;
                    wall.floorTexture = tile.floorTexture;
                    this.viewport.clip(wall.move(this.camera).clip());
                    int face = 0;
                    while (face < surface.walls.size()) {
                        wall = surface.walls.get(face).move(x, 0, z, rot);
                        this.viewport.renderWall(wall.move(this.camera).clip(), tile);
                        ++face;
                    }
                }
                ++rot;
            }
        } else {
            Wall wall;
            int face;
            this.viewport.unclip();
            int rot = 0;
            while (rot < 1) {
                Surface surface = tile.getWall(rot);
                if (surface != null) {
                    face = 0;
                    while (face < surface.walls.size()) {
                        wall = surface.walls.get(face).move(x, 0, z, rot);
                        this.viewport.renderWall(wall.move(this.camera).clip(), tile);
                        ++face;
                    }
                }
                ++rot;
            }
            Surface surface = Surface.floorAndCeiling;
            int rot2 = 0;
            while (rot2 < 4) {
                face = 0;
                while (face < surface.walls.size()) {
                    wall = surface.walls.get(face).move(x, 0, z, rot2);
                    wall.ceilingTexture = tile.ceilingTexture;
                    wall.floorTexture = tile.floorTexture;
                    this.viewport.renderWall(wall.move(this.camera).clip(), tile);
                    ++face;
                }
                ++rot2;
            }
        }
    }

    private void renderWalls(int xOffs, int zOffs, int maxDepth) {
        this.renderBlock(0, 0, xOffs, zOffs);
        int d = 0;
        while (!this.viewport.isFilled() && d < maxDepth) {
            ++d;
            int s = 0;
            while (s < d * 2) {
                if (this.viewport.isFilled()) {
                    return;
                }
                int flip = (s & 1) * 2 - 1;
                int step = (s + 1) / 2 * flip;
                this.renderBlock(step, -d, xOffs, zOffs);
                this.renderBlock(-step, d, xOffs, zOffs);
                this.renderBlock(-d, -step, xOffs, zOffs);
                this.renderBlock(d, step, xOffs, zOffs);
                ++s;
            }
        }
    }

    public void render(Viewport viewport, Camera camera, int tick, double alpha) {
        this.visibleTiles.clear();
        int maxDepth = 10;
        if (this.pick) {
            viewport.pick(this.xPick, this.yPick);
            maxDepth = 2;
        } else {
            viewport.clear(camera);
        }
        viewport.setCameraPos(camera);
        int xOffs = -((int)Math.floor((camera.x + this.level.wallWidth / 2.0) / this.level.wallWidth));
        int zOffs = -((int)Math.floor((camera.z + this.level.wallWidth / 2.0) / this.level.wallWidth));
        this.camera = camera;
        this.viewport = viewport;
        this.renderWalls(xOffs, zOffs, maxDepth);
        int i = 0;
        while (i < this.visibleTiles.size()) {
            this.renderSprites(this.visibleTiles.get(i).getRenderables(), tick, alpha);
            ++i;
        }
        this.level.renderSprites(viewport, camera, tick, alpha);
    }

    private void renderSprites(List<Renderable> sprites, int currentTick, double alpha) {
        int i = 0;
        while (i < sprites.size()) {
            sprites.get(i).render(this.viewport, this.camera, currentTick, alpha);
            ++i;
        }
    }

    public PickResult pick(int x, int y, Viewport viewport, Camera camera, int tick, double alpha) {
        PickResult pickResult;
        if (x < 0 || y < 0 || x >= viewport.width || y >= viewport.height) {
            return null;
        }
        this.pick = true;
        this.xPick = x;
        this.yPick = y;
        this.render(viewport, camera, tick, alpha);
        this.pick = false;
        Pickable.pickResult = pickResult = viewport.pickResult;
        return pickResult;
    }
}

