/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.chambered.display;

import com.mojang.chambered.display.bitmap.Bitmap;
import com.mojang.chambered.display.bitmap.BitmapCache;

public class Font {
    public static Font normal = new Font("/font/default.gif");
    private Bitmap texture;
    private int[] charWidths = new int[256];

    private Font(String name) {
        this.texture = BitmapCache.get(name);
        int i = 0;
        while (i < 128) {
            int xt = i % 16;
            int yt = i / 16;
            int x = 0;
            boolean emptyColumn = false;
            while (x < 8 && !emptyColumn) {
                int xPixel = xt * 8 + x;
                emptyColumn = true;
                int y = 0;
                while (y < 8 && emptyColumn) {
                    int yPixel = (yt * 8 + y) * this.texture.width;
                    int pixel = this.texture.pixels[xPixel + yPixel] & 0xFF;
                    if (pixel > 128) {
                        emptyColumn = false;
                    }
                    ++y;
                }
                ++x;
            }
            if (i == 32) {
                x = 4;
            }
            this.charWidths[i] = x;
            ++i;
        }
    }

    public void drawShadow(Bitmap target, String str, int x, int y, int color) {
        this.draw(target, str, x + 1, y + 1, color, true);
        this.draw(target, str, x, y, color);
    }

    public void draw(Bitmap target, String str, int x, int y, int color) {
        this.draw(target, str, x, y, color, false);
    }

    public void draw(Bitmap target, String str, int x, int y, int color, boolean darken) {
        char[] chars = str.toCharArray();
        if (darken) {
            color = (color & 0xFCFCFC) >> 2;
        }
        int xo = 0;
        int i = 0;
        while (i < chars.length) {
            if (chars[i] == '\u00a7') {
                int cc = "0123456789abcdef".indexOf(chars[i + 1]);
                int br = (cc & 8) * 8;
                int b = (cc & 1) * 191 + br;
                int g = ((cc & 2) >> 1) * 191 + br;
                int r = ((cc & 4) >> 2) * 191 + br;
                color = r << 16 | g << 8 | b;
                i += 2;
                if (darken) {
                    color = (color & 0xFCFCFC) >> 2;
                }
            }
            int ix = chars[i] % 16 * 8;
            int iy = chars[i] / 16 * 8;
            target.colorBlit(this.texture, x + xo, y, color, ix, iy, this.charWidths[chars[i]], 8);
            xo += this.charWidths[chars[i]];
            ++i;
        }
    }

    public int width(String str) {
        char[] chars = str.toCharArray();
        int len = 0;
        int i = 0;
        while (i < chars.length) {
            if (chars[i] == '\u00a7') {
                ++i;
            }
            len += this.charWidths[chars[i]];
            ++i;
        }
        return len;
    }
}

