/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.chambered;

import com.mojang.chambered.World;
import com.mojang.chambered.hero.Hero;

public class Party {
    public Hero[] heroes = new Hero[4];

    public Party(World world) {
        this.heroes = new Hero[]{new Hero(world, "Diana", "Mage", 0, 2, 46, 26, 8, 7), new Hero(world, "Green", "Ranger", 1, 0, 86, 55, 13, 14), new Hero(world, "Shera", "Warrior", 2, 3, 107, 46, 17, 15), new Hero(world, "Teron", "Priest", 3, 1, 31, 34, 5, 9)};
    }

    public void tick(int currentTick) {
        int i = 0;
        while (i < this.heroes.length) {
            this.heroes[i].tick(currentTick);
            ++i;
        }
    }

    public void allDrainPower(int cost) {
        int i = 0;
        while (i < this.heroes.length) {
            this.heroes[i].usePower(cost);
            ++i;
        }
    }

    public void hurt(int damage, int dir) {
        int i = 0;
        while (i < this.heroes.length) {
            int dmg;
            if ((i + 1 + dir) % 4 <= 1 && (dmg = (int)(Math.random() * (double)damage + Math.random() * (double)damage)) > 0) {
                this.heroes[i].hurt(dmg);
            }
            ++i;
        }
    }

    public boolean hasLiveHero() {
        int i = 0;
        while (i < this.heroes.length) {
            if (!this.heroes[i].isDead()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean run(int runTime) {
        int i = 0;
        while (i < this.heroes.length) {
            if (!this.heroes[i].isDead() && this.heroes[i].power == 0) {
                return false;
            }
            ++i;
        }
        if (runTime % 4 == 0) {
            i = 0;
            while (i < this.heroes.length) {
                if (!this.heroes[i].isDead()) {
                    this.heroes[i].run();
                }
                ++i;
            }
        }
        return true;
    }
}

